/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.dpaa.ui.panels.troubleshooting;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.swing.JMButton;
import com.jmorgan.swing.JMPanel;
import com.jmorgan.swing.JMTextField;
import com.jmorgan.swing.LabeledComponent;
import com.jmorgan.swing.component.ComponentFactory;
import com.jmorgan.util.StringUtility;
import com.jmorgan.util.logging.LMG;
import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.beans.Domain;
import com.kumbasoft.core.beans.ManagementCommandError;
import com.kumbasoft.core.beans.ManagementCommandStatus;
import com.kumbasoft.core.ui.AbstractPanel;
import com.kumbasoft.core.ui.ApplianceDomainChangeMonitor;
import com.kumbasoft.core.ui.KumbaCoreUIConstants;
import com.kumbasoft.core.util.DataPowerSSHClient;
import java.awt.Component;

public class TraceRoutePanel
extends AbstractPanel {
    private JMTextField tfHosts;
    private JMButton btnTraceRoute;
    private String cliCommand;
    private String commandDescription;

    public TraceRoutePanel() {
        super(KumbaCoreUIConstants.createBorderLayout());
        JMPanel controlsPanel = KumbaCoreUIConstants.createFlowLayoutPanel(0);
        this.tfHosts = new JMTextField();
        LabeledComponent lblHosts = new LabeledComponent("Host:", (Component)this.tfHosts, 100, 200);
        this.btnTraceRoute = ComponentFactory.createButton(null, "Trace Route", "Trace the route to the entered host.", true, this, "traceRoute", new Object[0]);
        controlsPanel.addAll(lblHosts, this.btnTraceRoute);
        this.add((Component)controlsPanel, "North");
    }

    @Reflected
    private void traceRoute() {
        String host = this.tfHosts.getText();
        if (StringUtility.isEmpty(host)) {
            return;
        }
        this.cliCommand = String.format("traceroute %s\n", host);
        this.commandDescription = String.format("Trace Route to %s", host);
        this.openResultsDialogAndSetWaitCursor(this.commandDescription);
        ApplianceDomainChangeMonitor.getInstance().invokeProcessByApplianceSelection(this, "traceRoute", true);
        this.waitForResultsDialogToCloseAndResetCursor();
    }

    @Reflected
    private void traceRoute(Appliance appliance) {
        DataPowerSSHClient dpSSHClient = new DataPowerSSHClient(appliance);
        if (!dpSSHClient.connect()) {
            logger.severe(() -> LMG.log("(appliance=%s):  Error Connecting to SSH", () -> appliance.getName()));
            this.showMessage("Error Connecting to the " + appliance.getName(), "The connection to the appliance via SSH could not be made.  Check the credientials for your appliance.");
            return;
        }
        Domain defaultDomain = appliance.getDomain("default");
        String responseMessage = String.format("(..Failed to resolve host name.*|.+?ms|%s)", dpSSHClient.getPromptString());
        try {
            String actualResponse;
            dpSSHClient.sendToDataPower(this.cliCommand);
            while (!(actualResponse = dpSSHClient.waitFor(responseMessage)).matches(dpSSHClient.getPromptString())) {
                if (actualResponse.contains("Failed to resolve host name")) {
                    ManagementCommandError error = new ManagementCommandError(appliance, defaultDomain, this.commandDescription, null, actualResponse);
                    this.commandResultsDialog.commandFailed(error);
                    break;
                }
                ManagementCommandStatus result = new ManagementCommandStatus(appliance, defaultDomain, this.commandDescription, null, actualResponse);
                this.commandResultsDialog.commandSucceeded(result);
            }
            dpSSHClient.sendToDataPower("exit\n");
            dpSSHClient.waitFor("Goodbye.");
            dpSSHClient.disconnect();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

