/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.ui;

import java.awt.geom.Rectangle2D;

public enum RectangleEdge {
    TOP,
    BOTTOM,
    LEFT,
    RIGHT;


    public static boolean isTopOrBottom(RectangleEdge edge) {
        return edge == TOP || edge == BOTTOM;
    }

    public static boolean isLeftOrRight(RectangleEdge edge) {
        return edge == LEFT || edge == RIGHT;
    }

    public static RectangleEdge opposite(RectangleEdge edge) {
        RectangleEdge result = null;
        if (edge == TOP) {
            result = BOTTOM;
        } else if (edge == BOTTOM) {
            result = TOP;
        } else if (edge == LEFT) {
            result = RIGHT;
        } else if (edge == RIGHT) {
            result = LEFT;
        }
        return result;
    }

    public static double coordinate(Rectangle2D rectangle, RectangleEdge edge) {
        double result = 0.0;
        if (edge == TOP) {
            result = rectangle.getMinY();
        } else if (edge == BOTTOM) {
            result = rectangle.getMaxY();
        } else if (edge == LEFT) {
            result = rectangle.getMinX();
        } else if (edge == RIGHT) {
            result = rectangle.getMaxX();
        }
        return result;
    }
}

