#include "main.h"
#include <../../SCSLib/SCServo.h>

uint8_t ID[2];
int16_t Position[2];
uint16_t Speed[2];
uint8_t ACC[2];
uint16_t Torque[2];

void setup(void)
{
  setEnd(0);//HLSΪС˴洢ṹ
  ID[0] = 1;//ID1
  ID[1] = 2;//ID2
  Speed[0] = 60;//ٶV=60*0.732=43.92rpm
  Speed[1] = 60;//ٶV=60*0.732=43.92rpm
  ACC[0] = 50;//ٶA=50*8.7deg/s^2
  ACC[1] = 50;//ٶA=50*8.7deg/s^2
  Torque[0] = 300;//ŤصT=500*6.5=3250mA
  Torque[1] = 300;//ŤصT=500*6.5=3250mA
}

void examples(void)
{
  //(ID1/ID2)ٶV=60*0.732=43.92rpmٶA=50*8.7deg/s^2ŤصT=500*6.5=3250mAP1=4095λ
  Position[0] = 4095;
  Position[1] = 4095;
  SyncWritePosEx2(ID, 2, Position, Speed, ACC, Torque);
  HAL_Delay((4095-0)*1000/(60*50) + (60*50)*10/(50) + 50);//[(P1-P0)/(V*50)]*1000+[(V*50)/(A*100)]*1000 + 50()

  //(ID1/ID2)ٶV=60*0.732=43.92rpmٶA=50*8.7deg/s^2ŤصT=500*6.5=3250mAP0=0λ
  Position[0] = 0;
  Position[1] = 0;
  SyncWritePosEx2(ID, 2, Position, Speed, ACC, Torque);
  HAL_Delay((4095-0)*1000/(60*50) + (60*50)*10/(50) + 50);//[(P1-P0)/(V*50)]*1000+[(V*50)/(A*100)]*1000 + 50()
}
