# Agentic Financial Workflow using AWS Bedrock

## 1. Project Overview

This project demonstrates an agentic AI workflow that uses AWS Bedrock to analyze financial transaction data through a structured reasoning loop: Plan → Act → Observe → Summarize → Reflect. The system simulates how modern FinTech and SMB platforms automate financial insights, starting from a simple CSV of transactions and gradually transforming it into structured outputs like categorized data, KPIs, and summaries. The workflow is orchestrated locally through Python, which sends prompts to Bedrock using boto3, while all outputs are stored on the user’s machine (with the option to use Amazon S3). The goal is not to build a full application, but to clearly document each reasoning stage and show how an AI model can support financial analysis in a transparent, step-by-step process similar to real-world bookkeeping and reporting tools. This project also includes an optional stretch goal that generates visual KPI charts to enhance financial interpretation.

---

## 2. Team Members & Roles
Prompt Engineer - Bushra
- Created the prompts used for each part of the agentic workflow, including the Plan, Categorization, KPI calculation, Summary, and Reflection stages.
- Ensured all prompts were clear and produced clean, valid JSON so the outputs could move smoothly through each step of the workflow.
- Used Claude 3.5 Sonnet on AWS Bedrock to generate the original plan.json file and adjusted the prompt until the model followed the correct five-step structure.
- Generated both categorized.json and kpis.json using the same model, running the Categorization and KPI prompts through Bedrock and checking the outputs for accuracy and proper formatting.
- Reviewed the model’s responses, corrected any formatting issues, and re-ran prompts when necessary to meet the project’s required schema.
- Collaborated with the Data Engineer and Financial Analyst to make sure the prompts aligned with the dataset and supported meaningful financial analysis.

Data Engineer - Abdul Sheikh: 
- Used Option B, generating through Python, because creating a CSV manually wouldn’t be as consistent since everyone in the group has different file paths and setups.
- Writing the Python script ensured the dataset could be recreated the same way on any machine, with no path or formatting issues.
- Built a clean transactions.csv with consistent columns and realistic values the rest of the team could use without problems.
- Cleaned and validated the data so it was ready for analysis.


Financial Analyst - Masumul Mozumder: 
- Reviews the transaction dataset to understand spending patterns and overall financial activity.
- Interprets the model’s outputs, including categorized transactions, KPIs, and the monthly summary.
- Checks whether the metrics and insights are financially accurate and reasonable for the dataset.
- Highlights key findings, trends, and potential concerns relevant to a small business or individual user.
- Contributes to the reflection stage by suggesting improvements to categories, metrics, or analysis rules.
- Ensures the final insights are clear, useful, and aligned with real FinTech and SMB reporting needs.

---

## 3. Dataset Description
- File name: data/transactions.csv
- Number of rows: 14
- Columns: date, merchant, amount, description
- Type of financial data: Personal finance (individual spending + income)
- Example row (optional): 2024-10-01, Amazon, 45.99, "Online shopping - household items"

This CSV contains a small set of personal finance transactions, including everyday purchases, subscriptions, bills, and one income entry. It’s suitable for this project because it has clean, well-structured fields (date, merchant, amount, description) and represents realistic financial activity that can be used to test data-cleaning, categorization, and analytics workflows.

---

## 4. Folder Structure

AgenticFinancialWorkflow/
├── data/                            # Input CSV dataset
│   └── transactions.csv
├── outputs/                         # Model outputs (all stages of the workflow + charts)
│   ├── plan.json                    # PLAN stage output
│   ├── categorized.json             # ACT (Categorization) stage output
│   ├── kpis.json                    # OBSERVE (KPI Computation) output
│   ├── summary.txt                  # SUMMARIZE stage output
│   ├── reflection.txt               # REFLECT stage output
│   └── plots/                       # KPI visualization images (stretch goal)
│       ├── income_vs_spend.png
│       ├── top_merchants.png
│       ├── category_spend.png
│       └── category_spend_pie.png
├── python_scripts/                   # Core Python scripts and notebooks
│   ├── create_csv.py                 # Script used to create or manage the CSV dataset
│   └── Phase2.ipynb                  # Jupyter notebook used during Plan → Reflect workflow
├── stretch_goals/
│   ├── Extra credit summary.txt      # SUMMARIZE comparison stage output
│   ├── Extra credit kpis.json        # OBSERVE (KPI Computation) output for both datasets to compare
│   ├── Extra credit categorized.json # ACT (Categorization) stage output for both dataset
│   ├── Extra credit plan.json        # PLAN comparison stage output
│   ├── data/                         # # Input extra credit CSV dataset
│   │   ├── transactions_extra_credit.xlsx
│   │   └── transactions_extra_credit.csv
│   ├── visualize_kpis.py             
│   └── ExtraCredit_create_csv.py.    # Script that generates another dataset used to compare financial data between two months
└── README.md                         # Project documentation


To provide clearer documentation of each file in the project, the following descriptions explain the purpose and contents of every key file and folder in the workflow:

data/transactions.csv
Contains the raw financial transaction records used as input for the workflow. Includes columns such as date, merchant, amount, and description. This file represents the starting point for the agentic analysis process.
It serves as the “truth source” that all subsequent stages depend on, making data accuracy critical. Any inconsistencies in this file would flow downstream into categorization, KPIs, and the final summary. It is intentionally small (14 rows) for clarity, but it reflects realistic everyday spending patterns used in FinTech platforms.

outputs/plan.json
The output from the PLAN stage. This file contains the 5-step workflow outlining how the model intends to perform the analysis across the Plan → Act → Observe → Summarize → Reflect sequence.
It documents the model’s reasoning blueprint and ensures all later stages follow a predictable structure. Because the plan is created by the LLM, it also reveals how the model internally interprets the dataset and task. This file is foundational because every subsequent step directly traces back to the decisions made in this plan.

outputs/categorized.json
The output from the ACT stage. This file lists each transaction with an assigned category (Shopping, Dining, Utilities, Income, Other). It serves as the foundation for KPI calculations.
Accurate categorization directly impacts financial insights, since every KPI depends on these labels. Errors in this file, such as misclassification or inconsistent formatting, can significantly distort the analysis. This mirrors how real tools like QuickBooks, Mint, or Wave rely heavily on category mapping logic for downstream analytics.

outputs/kpis.json
The output from the OBSERVE stage. Includes computed financial metrics such as total spending, total income, average expense amount, and the top merchants by spend. This file summarizes the dataset numerically.
These KPIs represent the core financial insights that would be used in real-world dashboards or reports. The structure of this file also enables clear auditability, helping validate that the generated metrics match the underlying data. KPIs in this file are deliberately simple, but they reflect standard starter metrics used by small businesses tracking monthly cash flow.

outputs/summary.txt
The output from the SUMMARIZE stage. Contains a short (≤100 words) natural-language summary describing the month’s financial activity using the KPIs and categories.
This file demonstrates how transformer models can convert structured financial data into a concise, readable narrative. It mirrors FinTech features like monthly spending summaries or cash-flow insights provided to end users. Because this summary is human-readable, it bridges the gap between raw KPIs and actionable insight, similar to modern AI-driven financial apps.

outputs/reflection.txt
The output from the REFLECT stage. Documents model-identified errors, categorization issues, KPI inconsistencies, and recommended improvements for future iterations.
This reflective step is essential for demonstrating agentic reasoning, as it forces the LLM to analyze its own outputs. It also provides guidance for enhancing prompts, rules, and overall workflow quality in future runs. This final stage emphasizes transparency and model self-evaluation, mirroring auditability requirements common in financial software.

outputs/plots/
Contains visualization images generated from the stretch-goal script. These include bar and pie charts for income vs spending, top merchants, and spending by category.
These visual outputs make the KPIs easier to interpret at a glance and simulate the kind of charts that would appear in a real FinTech dashboard.

python_scripts/create_csv.py
A script used to generate or reproduce the dataset. Ensures consistency across machines by programmatically creating transactions.csv rather than manually entering data.
It eliminates problems related to file paths, formatting discrepancies, or human error during data entry. This script also makes the project reproducible and easy to rerun on different environments.

python_scripts/Phase2.ipynb
A Jupyter notebook containing the code used during Phase 2 and subsequent analysis. It includes prompt calls, model invocation, validation steps, and troubleshooting experiments.
This notebook acts as the development environment where the agentic workflow was tested, debugged, and iterated on. It also serves as documentation of the engineering process, showing how each output was generated and verified. The notebook provides a transparent, reproducible sequence of cells that peers or instructors can run to verify each stage of the workflow.

stretch_goals/visualize_kpis.py
A standalone script implementing the visualization stretch goal. It loads outputs/kpis.json and outputs/categorized.json, computes category and merchant totals, and generates the four PNG charts saved in outputs/plots/.
This script demonstrates how the structured outputs from the agentic workflow can be reused for simple dashboard-style reporting without changing the core pipeline.

stretch_goals/ExtraCredit_create_csv.py
A standalone script implementing the extra credit dataset generation. It creates a second month of synthetic transaction data (November 2024) using the same schema as the main project (date, merchant, amount, description). 
This file can be fed into the same agentic workflow to compare financial trends between two months (e.g., changes in total spend, category patterns, or top merchants) without modifying the core pipeline.

stretch_goals/data/transactions_extra_credit.csv (.xlsx )
Contains an additional month of financial transactions for the extra-credit trend analysis. It follows the same structure as the main dataset providing a second month of spending and income for comparison. 
This file serves as the alternate input used to detect month-over-month changes in expenses, categories, and merchant activity.

---

## 5. Phase 2 – PLAN Prompt

```
You are a financial analysis agent.

You are given this month's transaction dataset with the following columns: date, merchant, amount, and description.

Your job is to design a clear 5-step analysis plan that follows this agentic reasoning pattern:
1. PLAN – Determine how you will approach analyzing the financial data.
2. ACT – Explain how you will process or classify the transactions.
3. OBSERVE – Describe how you will review or compute key financial metrics based on the processed data.
4. SUMMARIZE – Explain how you will turn the insights into a concise monthly financial summary.
5. REFLECT – Describe how you will evaluate the results and identify improvements for future analysis.

Each step must be specific to financial transaction analysis and must clearly reflect its position in the sequence Plan → Act → Observe → Summarize → Reflect.

Return your response ONLY in valid JSON using the exact structure below:

{
  "plan_steps": [
    "step 1 description...",
    "step 2 description...",
    "step 3 description...",
    "step 4 description...",
    "step 5 description..."
  ]
}

Do not include any text outside of the JSON. Do not add extra fields, commentary, labels, or explanations.
```
---

## 6. How `plan.json` Was Generated

Model used: Claude 3.5 Sonnet (via AWS Bedrock)
Method: Generated through a Python script that sends the Phase 2 PLAN prompt to Bedrock using the boto3 Bedrock Runtime client.
Date generated: November 2025

Notes:
The Python script executed the PLAN prompt exactly as written in Phase 2, 
enforced JSON-only output, and saved the model’s response into the outputs/plan.json file. This ensured consistency and reproducibility across machines.

---

## 7. Phase 2 – Categorization Prompt (Draft)
```
You are a financial transaction categorization agent.

You are given a list of monthly transactions with the following columns:
date, merchant, amount, and description.

Your task is to categorize each transaction into exactly one of the following categories based on the merchant name, transaction amount, and description:
Shopping, Dining, Utilities, Income, or Other.

Each transaction must receive only one category. Expenses such as purchases, meals, or services should be assigned to the appropriate category, and positive incoming amounts should be considered for the Income category when appropriate. If a transaction does not clearly fit any of the defined categories, assign it to Other.

Return your response ONLY in valid JSON using the exact structure below:

{
  "categorized": [
    {
      "date": "",
      "merchant": "",
      "amount": 0,
      "category": ""
    }
  ]
}

Do not include any text outside of the JSON. Do not add explanations, extra fields, comments, or labels. The JSON should contain a complete list entry for every transaction provided.
```
---

## 8. Categorization Prompt 

```
Given the list of monthly transactions with the fields: date, merchant, amount, and description.

Your task is to assign each transaction to exactly one of the following categories:
Shopping, Dining, Utilities, Income, or Other.

Use both the merchant name and the description to determine the most reasonable category. 
Incoming money (negative amounts in this dataset) should be labeled as Income. 
If a transaction does not clearly belong to any category, classify it as Other.

Return ONLY valid JSON in the following structure:

{
  "categorized": [
    {
      "date": "",
      "merchant": "",
      "amount": 0,
      "category": ""
    }
  ]
}

Do not include explanations, comments, or any text outside the JSON.
The JSON must include a complete entry for every transaction.

```

## 9. How `categorization.json` Was Generated

Model used: Claude 3.5 Sonnet (via AWS Bedrock)

Method: To generate the categorized.json file, I loaded the transactions from transactions.csv and
sent them to Claude 3.5 Sonnet along with the final categorization prompt. The script simply
passed the list of rows into the model and asked it to return the categories in the required
JSON structure. Once the model responded, I checked that every transaction was included and
that the JSON followed the exact format the project requires. After confirming the schema was
clean and valid, I saved the output as categorized.json in the outputs folder.

Notes:
- double-checked that each transaction only had one category.
- verified the formatting because the model sometimes adds extra text if the prompt isn’t strict.
- A few runs were needed before the JSON was perfectly clean.

## 10. KPIs prompt
```
Now use the list of categorized financial transactions. Each entry contains:
date, merchant, amount, and category.

Using this data, compute the following KPIs:

1. total_spend: the sum of all positive expense amounts
2. total_income: the sum of all negative income amounts, returned as a positive number
3. top_merchants: the three merchants with the highest total spending, after aggregating all transactions for each unique merchant. In case of a tie, prioritize the merchant with the higher number of transactions. 
4. average_expense: the average of all positive expense amounts

Return your response ONLY in valid JSON using the exact structure below:

{
  "kpis": {
    "total_spend": 0,
    "total_income": 0,
    "top_merchants": [],
    "average_expense": 0
  }
}

Do not include any text outside of the JSON. Do not add explanations, commentary, or extra fields.

```

## 11. How `KPIs.json` Was Generated

Model used: Claude 3.5 Sonnet (via AWS Bedrock)

Method: Once the categorization step was done, I used the categorized.json file as the input for the KPI prompt. The same Python script setup was used to call Claude 3 Sonnet through Bedrock. The
model calculated the required metrics (total spend, total income, top merchants, average
expense) and returned them in the JSON format described in the project instructions. After the
response came back, I checked the values against the dataset to make sure the amounts and
merchant rankings made sense before saving the file as kpis.json.

Notes:
- re-calculated a few numbers to make sure the KPIs matched the dataset.
- The top merchants list was compared with the categorized transactions to confirm accuracy.
- The file was only saved after confirming the JSON structure matched the specification exactly.

## 12. How 'Summary.txt' was Generated
Here’s a simple README you can use (or paste into `README.md`):
Model used: Claude 3 Sonnet (via AWS Bedrock)
---

### Summarization Prompt

Using the categorized transactions and KPIs provided, write a short (maximum 100 words) financial summary describing this month’s spending and income.

The summary should:

* Highlight major spending categories
* Mention total expenses and total income
* Identify top merchants if relevant
* Provide an overall insight into financial health
* Be readable and professional

Return ONLY plain text (no JSON).

---

### How the Summary.txt Was Generated

1. Loaded the KPIs JSON to obtain total income, total spend, average expense, and top merchants.
2. Loaded the categorized transactions JSON to identify the main spending categories (e.g., Shopping, Dining, Utilities, Other) and confirm that Paycheck was the only income transaction.
3. Used the prompt above to manually draft a ≤100-word summary that:

   * States total income and total spending
   * Highlights the largest expense category and other key categories
   * Includes the named top merchants
   * Comments on overall cash flow and financial health

### KPIs Used

From the `kpis` JSON object, the KPIs used in the summary:

**total_spend**: `731.13`
**total_income**: `2500`
**top_merchants**: `["Costco", "Apple Store", "AT&T"]`
**average_expense**: `56.24`

These KPIs were combined with the categorized transaction data to describe where money was spent, how much was earned, and the resulting financial position for the month.

---
## 13. FinTech Relevance

This workflow reflects how real FinTech and small business platforms turn raw transaction data into meaningful financial insights. By starting with a basic CSV and moving through structured reasoning steps, the project shows how tasks like expense categorization, KPI tracking, and monthly reporting can be handled in a clear, repeatable way. Small businesses often have limited financial staff, so an automated process like this can reduce manual bookkeeping, reveal spending patterns, identify major vendors, and support budgeting decisions. Because each stage produces a separate, traceable output file, the workflow also aligns with the transparency and audit needs commonly found in financial reporting. Overall, this project demonstrates how a lightweight, low-cost AI process powered by AWS Bedrock can help individuals and SMBs better understand their financial activity and make more informed decisions.

---

## 14. Reflection Summary

The reflection stage revealed several inconsistencies and improvement opportunities across categorization, KPI computation, and prompt clarity. Misclassifications occurred when the model labeled Shell Gas as Utilities instead of Transportation, Uber as Other instead of Transportation, and Spotify as Other instead of Subscriptions/Entertainment. These issues highlight the need for stronger merchant-based rules (e.g., gas-related keywords → Transportation; ride-sharing → Transportation; streaming services → Subscriptions).

While total spending and average expense were correct, the original top_merchants list incorrectly replaced AT&T with Whole Foods despite AT&T having higher total spend. This demonstrated the need for explicit sorting instructions in the KPI prompt. The reflection also recommended structuring merchant entries as { "merchant": "", "total": "" } for clarity. Overall, the reflection process demonstrated why agentic workflows benefit from explicit rules, schema enforcement, and validation steps.

---

## 15. Reflection Prompt 
Model used: Claude 3.5 Sonnet (via AWS Bedrock)

## Reflection Prompt
* Review all prior outputs (categorized transactions and KPIs) and write a reflection that:
* Identifies incorrect or questionable categories
* Identifies KPI errors or inconsistencies
* Suggests rules to improve the categorization logic
* Suggests prompt modifications for better KPI extraction
* Provides a clear, model-driven reasoning process
Return ONLY plain text (no JSON).

## How the reflection.txt Was Generated
1. Loaded categorized.json to review each merchant and its assigned category (Shopping, Dining, Utilities, Income, Other).
2. Loaded kpis.json to verify total_spend, total_income, average_expense, and the top_merchants list against the raw transactions.
3. Manually re-checked the transaction list to spot questionable categories (e.g., Shell Gas, Uber, Spotify) and compare them to more natural category choices like Transportation or Subscriptions/Entertainment.
4. Recomputed or sanity-checked the KPIs (total_spend and average_expense) and compared them with the top_merchants list to see whether the merchants truly reflect the highest spend.
5. Used the reflection prompt above to write a structured analysis that:
   * Highlights questionable categorization choices and suggests rule-based improvements.
   * Points out conceptual inconsistencies in KPIs (especially top_merchants) even when the arithmetic is correct.
   * Proposes clearer rules and prompt language for computing KPIs (e.g., how to define top_merchants, how to handle income signs, how to validate totals).
   * Summarizes how comparing KPIs back to raw transactions helps catch errors and improve future runs of the agentic financial workflow.
---

## 16. Stretch Goal: KPI Visualizations

As part of the optional enhancement, KPI visualizations were added to make the financial insights easier to understand and more presentation-ready. A new script, stretch_goals/visualize_kpis.py, reads the existing categorized.json and kpis.json files, computes totals by category and merchant, and generates four charts using matplotlib. These visualizations are saved in the outputs/plots/ directory and include income-versus-spending, top-merchant totals, category spending, and a spending distribution pie chart.

These additions help translate numerical outputs into clear visuals that resemble real FinTech dashboards. They make the workflow easier for non-technical audiences to interpret, demonstrate how structured agentic outputs can feed end-user reporting interfaces, and increase the overall professionalism and completeness of the project.

---

## 17. JSON Troubleshooting

During the workflow, several common issues occurred when generating JSON outputs. Below is a concise summary of the problems and how they were resolved:

1. Extra Text Outside JSON
Some model responses included explanations before or after the JSON block, which violated the “JSON only” requirement.
Fix: Strengthened prompt language (“Return ONLY valid JSON”) and re-ran outputs until they contained a single valid JSON object.

2. Missing or Incorrect Entries in categorized.json
A few runs omitted transactions or produced objects missing required fields.
Fix: Counted entries to match the CSV row count, checked field completeness, and re-ran with stricter prompts.

3. KPI Structure / Value Validation Issues
The JSON structure was correct, but values (e.g., top merchants, totals) sometimes needed verification.
Fix: Manually recomputed totals and averages to confirm accuracy and ensured top_merchants reflected actual highest spend.

4. Income Sign Handling
Income values appear negative in the dataset but must be reported as positive in KPIs.
Fix: Confirmed the model converted negative income amounts into positive totals and excluded them from expense averages.

---

## 18. Lessons Learned

- Prompt strictness is essential. For example, without “ONLY return JSON,” the model frequently added commentary or formatting errors.
- Small categorization inconsistencies can cascade into incorrect KPIs and summaries.
- Team collaboration across the Prompt Engineer, Data Engineer, and Financial Analyst roles ensured every step was validated.
- The reflection step proved valuable for uncovering hidden issues not obvious during initial workflow execution
- Visualizing KPIs demonstrated the importance of validating numerical outputs before plotting, since errors become more noticeable in visual form.

---

## 19. How to Re-Run This Workflow

1. Ensure AWS credentials are set up with access to Bedrock models.
2. Run create_csv.py if you need to regenerate the transactions.csv dataset.
3. Open and run Phase2.ipynb sequentially, executing each stage: Plan → Categorize → KPIs → Summary → Reflection.
4. Outputs will be automatically saved to the outputs/ folder.
5. Review reflection.txt and, if needed, update prompts before re-running.

---

## 20. Limitations & Future Improvements

- Current categories are simplified; real SMB financial systems use more granular taxonomies like Transportation, Subscriptions, Insurance, Rent, etc.
- KPI coverage is minimal; future versions could add cash-flow trends, category breakdowns, anomaly detection, and vendor aggregation.
- Reflection is a single-pass process; implementing an automated reflection → correction → re-run loop would make this workflow more agentic.
- Charts cover only one month; future improvements could add multi-month trends and comparative visuals.

---

## 21. Data Set (Extra Credit)

## How 'ExtraCredit_create_csv' was Generated: 
The script was created by taking the original transactions.csv structure (date, merchant, amount, description) and generating a second month of realistic financial data for comparison.
A new Python file was written to load this new dataset into a DataFrame and export it as both CSV and Excel. The code follows the same format, folder structure, and naming conventions as the original script so it integrates smoothly into the existing workflow. 
The output files were saved inside the stretch_goals/data/ directory as transactions_extra_credit.csv and .xlsx, allowing the agentic pipeline to detect spending trends across two months.

##22. PLAN Prompt

```
You are a financial trend analysis agent.

You are given two months of financial transaction data. Your job is to design a clear 5-step comparison plan that follows the agentic reasoning pattern:

1. PLAN – Determine how you will compare Month 1 and Month 2 financial activity.
2. ACT – Explain how you will process and categorize the transactions from both months.
3. OBSERVE – Describe how you will compute trend KPIs such as spending changes, income changes, category differences, and merchant-level changes.
4. SUMMARIZE – Explain how you will convert the comparison results into a clear month-to-month trend summary.
5. REFLECT – Describe how you will evaluate patterns and identify improvements for future trend detection.

Return your response ONLY in valid JSON using the exact structure below:

{
  "plan_steps": [
    "step 1 description...",
    "step 2 description...",
    "step 3 description...",
    "step 4 description...",
    "step 5 description..."
  ]
}

Do not include any text outside of the JSON. Do not add explanations, comments, or extra fields.

```
---

## 23. How `plan.json` Was Generated

Model used: Claude 3.5 Sonnet (via AWS Bedrock)
Method: Generated through a Python script that sends the Phase 2 PLAN prompt to Bedrock using the boto3 Bedrock Runtime client.
Date generated: December 2025

Note: 
The script submitted the full trend plan prompt and saved the model’s JSON-only output as plan.json. 
This ensured a reproducible workflow identical to the earlier Phase 2 plan step.
---

## 24. Categorization Prompt 

```
You are a financial transaction categorization agent.

You are given two months of financial transactions. Each transaction has:
date, merchant, amount, and description.

Your task is to categorize each transaction into exactly one of the following categories:
Shopping, Dining, Utilities, Income, Other.

Categorize Month 1 and Month 2 separately.

Return ONLY valid JSON in this format:

{
  "month1_categorized": [
    {
      "date": "",
      "merchant": "",
      "amount": 0,
      "category": ""
    }
  ],
  "month2_categorized": [
    {
      "date": "",
      "merchant": "",
      "amount": 0,
      "category": ""
    }
  ]
}

Do not include any text outside the JSON. Do not add extra commentary, labels, or fields.


```

## 25. How `categorization.json` Was Generated

Model used: Claude 3.5 Sonnet (via AWS Bedrock)

Both months’ transactions were loaded from their CSV files and passed into the categorization prompt through the same Python script used in earlier phases. Claude 3.5 Sonnet returned the categories in the required JSON format.
The output was inspected to ensure:
Every transaction was categorized exactly once
The JSON format matched the required schema
No extra text or commentary was added
Once validated, it was saved as categorized.json.

Notes:
Verified that each transaction contained exactly one category
Ensured strict formatting because models may add extra text if the prompt is not strict
A few runs were needed before the JSON was perfectly clean

## 26. KPIs prompt
```
You are a financial analysis agent.

You are given two months of categorized transactions. Your task is to compute the key trend KPIs comparing Month 1 and Month 2, including:

- spend_change: difference in total spending between the two months
- income_change: difference in total income between the two months
- category_changes: spending increases or decreases for each category
- top_increasing_merchants: merchants where spending increased the most
- top_decreasing_merchants: merchants where spending decreased the most

Return ONLY valid JSON using the structure below:

{
  "trend_kpis": {
    "spend_change": 0,
    "income_change": 0,
    "category_changes": {
      "Shopping": 0,
      "Dining": 0,
      "Utilities": 0,
      "Income": 0,
      "Other": 0
    },
    "top_increasing_merchants": [],
    "top_decreasing_merchants": []
  }
}

Do not include any text outside the JSON. Do not add extra fields or commentary.

```

## 27. How `KPIs.json` Was Generated

Model used: Claude 3.5 Sonnet (via AWS Bedrock)

Method:
Using the categorized outputs from both months, the KPI prompt was sent to Claude 3.5 Sonnet. The model computed month-to-month differences (spending, income, category changes, and merchant-level trends) and returned results in strict JSON format.
Before saving:
Spending and income differences were recalculated manually
Merchant totals were checked to ensure the ranking order was correct
The JSON schema was validated against the assignment requirements
After confirming accuracy, the output was saved as trend_kpis.json.

Notes:
Manual quality checks were required because earlier runs had incorrect merchant rankings
Ensured category changes reflected correct summations across each month

## 28. How 'Summary.txt' was Generated
Here’s a simple README you can use (or paste into `README.md`):
Model used: Claude 3.5 Sonnet (via AWS Bedrock)
---

### Summarization Prompt

You are a financial summary agent.

You are given trend KPIs comparing Month 1 and Month 2. Your job is to produce a concise written summary that explains the major financial differences between the months, including spending changes, income changes, biggest category differences, and notable merchant-level shifts.

Return ONLY the summary text, written in 4–6 short sentences, with no JSON, no labels, and no additional structure.
---



