import pandas as pd
import os

data = [
    ["2024-10-01", "Amazon", 45.99, "Online shopping - household items"],
    ["2024-10-01", "Starbucks", 8.25, "Coffee and snack"],
    ["2024-10-02", "Trader Joe's", 76.40, "Grocery shopping"],
    ["2024-10-02", "Uber", 22.50, "Transportation ride"],
    ["2024-10-03", "Blue Bottle", 6.50, "Coffee"],
    ["2024-10-03", "Costco", 185.75, "Monthly groceries"],
    ["2024-10-04", "Chipotle", 14.10, "Lunch"],
    ["2024-10-05", "Spotify", 10.99, "Subscription service"],
    ["2024-10-05", "Apple Store", 120.00, "Electronics purchase"],
    ["2024-10-06", "Shell Gas", 42.30, "Gas refill"],
    ["2024-10-06", "Whole Foods", 84.60, "Groceries"],
    ["2024-10-07", "Paycheck", -2500.00, "Monthly salary incoming"],
    ["2024-10-07", "AT&T", 95.00, "Phone and internet bill"],
    ["2024-10-08", "Domino's", 18.75, "Food takeout"],
]

# Create DataFrame
df = pd.DataFrame(data, columns=["date", "merchant", "amount", "description"])

# Make sure data/ exists
os.makedirs("data", exist_ok=True)

# Save as CSV
csv_path = os.path.join("data", "transactions.csv")
df.to_csv(csv_path, index=False)

# Save as Excel
excel_path = os.path.join("data", "transactions.xlsx")
df.to_excel(excel_path, index=False)

print("transactions.csv and transactions.xlsx created successfully!")
print("CSV path:   ", os.path.abspath(csv_path))
print("Excel path: ", os.path.abspath(excel_path))

print("\nPreview of data:")
print(df.head())

