import pandas as pd
import os

# New dataset for November (Extra Credit)
extra_data = [
    ["2024-11-01", "Amazon", 52.10, "Online shopping – household essentials"],
    ["2024-11-01", "Starbucks", 7.95, "Coffee and snack"],
    ["2024-11-02", "Trader Joe's", 88.20, "Grocery shopping"],
    ["2024-11-02", "Lyft", 19.80, "Transportation ride"],
    ["2024-11-03", "Blue Bottle", 5.95, "Coffee"],
    ["2024-11-03", "Costco", 162.40, "Groceries and supplies"],
    ["2024-11-04", "Chipotle", 13.50, "Lunch"],
    ["2024-11-05", "Netflix", 15.49, "Subscription service"],
    ["2024-11-05", "Best Buy", 210.00, "Electronics purchase"],
    ["2024-11-06", "Shell Gas", 39.70, "Gas refill"],
    ["2024-11-06", "Whole Foods", 72.30, "Groceries"],
    ["2024-11-07", "Paycheck", -2500.00, "Monthly salary incoming"],
    ["2024-11-07", "Verizon", 105.00, "Phone and internet bill"],
    ["2024-11-08", "McDonald's", 11.25, "Food takeout"],
    ["2024-11-09", "Target", 64.90, "Household shopping"],
    ["2024-11-10", "Panera Bread", 16.40, "Dining"]
]

# Create DataFrame
df2 = pd.DataFrame(extra_data, columns=["date", "merchant", "amount", "description"])

# Ensure folder exists
os.makedirs("data", exist_ok=True)

# Save CSV + Excel
csv_path = os.path.join("data", "transactions_extra_credit.csv")
excel_path = os.path.join("data", "transactions_extra_credit.xlsx")

df2.to_csv(csv_path, index=False)
df2.to_excel(excel_path, index=False)

print("Extra-credit datasets created successfully!")
print("CSV path:   ", os.path.abspath(csv_path))
print("Excel path: ", os.path.abspath(excel_path))

print("\nPreview of extra-credit data:")
print(df2.head())
