#region Using declarations
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.ComponentModel.DataAnnotations;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Input;
using System.Windows.Media;
using System.Xml.Serialization;
using NinjaTrader.Cbi;
using NinjaTrader.Gui;
using NinjaTrader.Gui.Chart;
using NinjaTrader.Gui.SuperDom;
using NinjaTrader.Gui.Tools;
using NinjaTrader.Data;
using NinjaTrader.NinjaScript;
using NinjaTrader.Core.FloatingPoint;
using NinjaTrader.NinjaScript.DrawingTools;
using System.IO;

#endregion

//This namespace holds Indicators in this folder and is required. Do not change it. 
namespace NinjaTrader.NinjaScript.Indicators.ABC123
{
	  [Gui.CategoryOrder("Template", 0)] 
	  [Gui.CategoryOrder("Parameters", 2)] 
	
  	 public class ABC123SBlockInformation
        {

            public int NumberOfContracts;
            public string BidAskMarket;
            public DateTime TimeRecorded;
            public double ClosePrice;

            //TASK: NOT SURE IF IT SETS OR GETS THE PivotPoint INFORMATION							
            //VALUE: TYPE, DATETIME, BAR ,VALUE
            public ABC123SBlockInformation(int nNumberOfContracts, string sBidAskMarket, DateTime tTimeRecorded, double dClosePrice)// double dBidPrice, long lBidVolume)
            {
                NumberOfContracts = nNumberOfContracts;
                BidAskMarket = sBidAskMarket;
                TimeRecorded = tTimeRecorded;
                ClosePrice = dClosePrice;

            }
        }
	
	public class ABC123siBlockScanner : Indicator
    {
		
		
  

        public double Volume0 = 0;
        public double Volume1 = 0;
        public int blocknumber = 0;
        public double contracts = 0;
        public int number = 0;
        private bool bDataLoaded = false;
        int nBid = 0;
        public bool bFirstTick = false;
		int tChartTimeFrameInMinutes =1;

 

        protected override void OnStateChange()
        {
            if (State == State.SetDefaults)
            {
                Description = @"Enter the description for your new custom Indicator here.";
                Name = "ABC123siBlockScanner";
                Calculate = Calculate.OnEachTick;
                IsOverlay = true;
                DisplayInDataBox = false;
                DrawOnPricePanel = false;
                PaintPriceMarkers = false;
                ScaleJustification = NinjaTrader.Gui.Chart.ScaleJustification.Right;
                //Disable this property if your indicator requires custom values that cumulate with each new market data event. 
                //See Help Guide for additional information.
                IsSuspendedWhileInactive = true;
                IsAutoScale = false;

              
 // List<NinjaTrader.NinjaScript.Indicators.ABC123BlockScanner.TachEonTimeWarpPivotPoint> list = new List<NinjaTrader.NinjaScript.Indicators.ABC123BlockScanner.TachEonTimeWarpPivotPoint>();
   

					//ABC123SingleIndicator
                //***********************************************************************************************
                //***********************************************************************************************
                //***********************************************************************************************
                //***********************************************************************************************
                //******************ABC123TRADING LICENCING***************************************************************
                //***********************************************************************************************
                //***********************************************************************************************
                //***********************************************************************************************
                string mod = "ABC123SingleIndicator";
                string vend = "ABC123Trader";
                string email = "abc123tradercom.register@gmail.com";
                string url = "https://abc123trader.com";

                VendorLicense(vend, mod, url, email);   //verify vendor licence

            }else if(State == State.Configure)
			{
				  //THIS IS THE TIMEFRAME OF THE CHART
                tChartTimeFrameInMinutes = BarsPeriod.Value;
				   Name = "";
				
				
				
				
				
			//	List<NinjaTrader.NinjaScript.Indicators.ABC123BlockScanner.ABC123SBlockInformation> recordedList = new List<NinjaTrader.NinjaScript.Indicators.ABC123BlockScanner.ABC123SBlockInformation>();
			}
            else if (State == State.Transition)
            {
                bDataLoaded = true;
            }
        }

        protected override void OnBarUpdate()
        {
            if (State == State.Historical) return;

            if (bDataLoaded == true)
            {
                testCode2();
            }
      
		//	this.blockList.Clear();
		
			
		
		}


        public void testCode2()
        {
            Volume0 = Volume[0];

			
		//	if (Close[0] == GetCurrentAsk())
		//	Print(GetCurrentAskVolume() + " ASK");
			
		//	  if (Close[0] == GetCurrentBid())
		//	Print(GetCurrentBidVolume() + " BID");
			
	//		Print(Volume0 + "  VOLUME");
			
			
            if ((Volume0 - Volume1) > nLargeBlockSize0)
            {
                if (bFirstTick == false)
                {
                    bFirstTick = true;
                }
                else
                {
                    if (Close[0] == GetCurrentBid())

                    {
                        Draw.HorizontalLine(this, "block" + blocknumber.ToString(), false, Close[0], eSwingTradeColor, DashStyleHelper.Dash, 2);
                        contracts = contracts - Volume0;

                        Draw.Text(this, "Block" + nBid, "BID: " + (Volume0 - Volume1).ToString(), 0, Close[0] + nTickOffset * TickSize);
                        nBid = nBid + 1;

                        if (bDisplayVerticalLine == true)
                            Draw.VerticalLine(this, "vertical" + blocknumber.ToString(), Time[0], eSwingTradeColor, DashStyleHelper.Dash, 2);

                    }
                    else
if (Close[0] == GetCurrentAsk())

                    {
                        contracts = contracts + Volume0;                     

                        if (bDisplayHorizontalLine == true)
                            Draw.HorizontalLine(this, "block" + blocknumber.ToString(), false, Close[0], eSwingTradeColor, eLevel2LineStyle, nLineWidth);

                        Draw.Text(this, "Block" + nBid, "ASK: " + (Volume0 - Volume1).ToString(), 0, Close[0] + nTickOffset * TickSize);
                        nBid = nBid + 1;

                        if (bDisplayVerticalLine == true)
                            Draw.VerticalLine(this, "vertical" + blocknumber.ToString(), Time[0], eSwingTradeColor, eLevel2LineStyle, nLineWidth, true);
                    }

                    else
                    {
                        if (bDisplayHorizontalLine == true)
                            Draw.HorizontalLine(this, "block" + blocknumber.ToString(), false, Close[0], eSwingTradeColor, eLevel2LineStyle, nLineWidth);

                        Draw.Text(this, "Block" + nBid, "Market: " + (Volume0 - Volume1).ToString(), 0, Close[0] + nTickOffset * TickSize);
                        nBid = nBid + 1;

                        if (bDisplayVerticalLine == true)
                            Draw.VerticalLine(this, "vertical" + blocknumber.ToString(), Time[0], eSwingTradeColor, eLevel2LineStyle, nLineWidth, true);
                    }

                    number = number + 1;

                    if (blocknumber == nMaxMajorLines)
                    {
                        blocknumber = 0;
                    }
                    blocknumber = blocknumber + 1;
                }
            }
            Volume1 = Volume0;
        }


        //********************************************************************************************************
        //GIVEN: nNumberOfDays
        //TASK:  changes the algorithm from calander days to trading days
        //RETURN: list
        //********************************************************************************************************
   


  

        private int nLargeBlockSize0 = 50;
        //	    [Browsable(false)]
        //    [NinjaScriptProperty]
        [Display(ResourceType = typeof(Custom.Resource), Name = "Large Block Size", GroupName = "Volume Blocks")]
        public int LargeBlockSize0
        {
            get { return nLargeBlockSize0; }
            set { nLargeBlockSize0 = value; }
        }

        private int nMaxMajorLines = 5;
        //	    [Browsable(false)]
        //	[NinjaScriptProperty]
        [Display(ResourceType = typeof(Custom.Resource), Name = "Number of Block Lines", GroupName = "Volume Blocks")]
        public int MaxMajorLines
        {
            get { return nMaxMajorLines; }
            set { nMaxMajorLines = value; }
        }

        private Brush eSwingTradeColor = Brushes.Ivory;
        [XmlIgnore()]
        //     [NinjaScriptProperty]
        [Display(Name = "Block Trade Color", Description = "", GroupName = "Parameters", Order = 2)]
        public Brush SwingTradeColor
        {
            get { return eSwingTradeColor; }
            set { eSwingTradeColor = value; }
        }
        // Serialize Color object
        [Browsable(false)]
        public string eSwingTradeColorSerialize
        {
            get { return Serialize.BrushToString(eSwingTradeColor); }
            set { eSwingTradeColor = Serialize.StringToBrush(value); }
        }


        private int nLineWidth = 1;
        //	[NinjaScriptProperty]		
        [Display(Name = "Line Width", Order = 4, GroupName = "Parameters")]
        public int LineWidth
        {
            get { return nLineWidth; }
            set { nLineWidth = Math.Max(1, value); }
        }

        private DashStyleHelper eLevel2LineStyle = DashStyleHelper.Solid;
        //     [NinjaScriptProperty]
        [Display(ResourceType = typeof(Custom.Resource), Name = "Line Style", GroupName = "Parameters", Order = 3)]
        public DashStyleHelper Level2LineStyle
        {
            get { return eLevel2LineStyle; }
            set { eLevel2LineStyle = value; }
        }

        private bool bDisplayHorizontalLine = true;
        //	[Browsable(false)]
        //    [NinjaScriptProperty]
        [Display(ResourceType = typeof(Custom.Resource), Name = "Display Horizontal Line", GroupName = "Parameters", Order = 0)]
        public bool DisplayHorizontalLine
        {
            get { return bDisplayHorizontalLine; }
            set { bDisplayHorizontalLine = value; }
        }

        private bool bDisplayVerticalLine = false;
        //	[Browsable(false)]
        //    [NinjaScriptProperty]
        [Display(ResourceType = typeof(Custom.Resource), Name = "Display Vertical Line", GroupName = "Parameters", Order = 1)]
        public bool DisplayVerticalLine
        {
            get { return bDisplayVerticalLine; }
            set { bDisplayVerticalLine = value; }
        }

        private int nTickOffset = 3;
        //	[Browsable(false)]
        //      [NinjaScriptProperty]
        [Display(ResourceType = typeof(Custom.Resource), Name = "Tick Offset", GroupName = "Parameters", Order = 8)]
        public int TickOffset
        {
            get { return nTickOffset; }
            set { nTickOffset = Math.Max(0, value); }
        }

		
		//#####################################################################################################
		
		
		
		
		
		
		

    }
}

#region NinjaScript generated code. Neither change nor remove.

namespace NinjaTrader.NinjaScript.Indicators
{
	public partial class Indicator : NinjaTrader.Gui.NinjaScript.IndicatorRenderBase
	{
		private ABC123.ABC123siBlockScanner[] cacheABC123siBlockScanner;
		public ABC123.ABC123siBlockScanner ABC123siBlockScanner()
		{
			return ABC123siBlockScanner(Input);
		}

		public ABC123.ABC123siBlockScanner ABC123siBlockScanner(ISeries<double> input)
		{
			if (cacheABC123siBlockScanner != null)
				for (int idx = 0; idx < cacheABC123siBlockScanner.Length; idx++)
					if (cacheABC123siBlockScanner[idx] != null &&  cacheABC123siBlockScanner[idx].EqualsInput(input))
						return cacheABC123siBlockScanner[idx];
			return CacheIndicator<ABC123.ABC123siBlockScanner>(new ABC123.ABC123siBlockScanner(), input, ref cacheABC123siBlockScanner);
		}
	}
}

namespace NinjaTrader.NinjaScript.MarketAnalyzerColumns
{
	public partial class MarketAnalyzerColumn : MarketAnalyzerColumnBase
	{
		public Indicators.ABC123.ABC123siBlockScanner ABC123siBlockScanner()
		{
			return indicator.ABC123siBlockScanner(Input);
		}

		public Indicators.ABC123.ABC123siBlockScanner ABC123siBlockScanner(ISeries<double> input )
		{
			return indicator.ABC123siBlockScanner(input);
		}
	}
}

namespace NinjaTrader.NinjaScript.Strategies
{
	public partial class Strategy : NinjaTrader.Gui.NinjaScript.StrategyRenderBase
	{
		public Indicators.ABC123.ABC123siBlockScanner ABC123siBlockScanner()
		{
			return indicator.ABC123siBlockScanner(Input);
		}

		public Indicators.ABC123.ABC123siBlockScanner ABC123siBlockScanner(ISeries<double> input )
		{
			return indicator.ABC123siBlockScanner(input);
		}
	}
}

#endregion
