# Epistheon
## Canonical Logic Mode Separation (CLMS)

---

## Global Signature

**Canonical Filename**  
OT0-epistheon-CLMS-root-spec-v1.0.0.md

**Title**  
Epistheon

**Subtitle**  
Canonical Logic Mode Separation (CLMS)

**Global ID**  
epistheon:CLMS

**Output Type**  
OT0

**Role**  
root-spec

**Version**  
v1.0.0

**Status**  
Canonical · Binding · Closed

**System Position**  
Epistemic Operating System — Logic Mode Boundary Specification

**System References**  
- epistheon:EPH  
- epistheon:CFILS  
- cots:COTS

**Author**  
Harald Meier

**Contact**  
harald@digitalspacelab.com

**License**  
Creative Commons Attribution–NonCommercial 4.0 International (CC BY-NC 4.0)

---

## Purpose

This document defines a **strict and binding separation between two logic modes** required to operate Epistheon across deterministic system layers and probabilistic large language models.

Its purpose is to preserve **architectural invariance** while enabling **LLM-compatible interpretive operation** without authority drift.

---

## Core Principle

**Deterministic system logic and interpretive guidance logic must never merge.**  
They may describe the same system state, but they may not share authority.

---

## Logic Mode A
### Deterministic System Logic (DSLg)

**Function**  
Defines invariant system structure, authority, identity, loading order, and termination conditions.

**Characteristics**
- deterministic
- invariant-based
- contradiction-intolerant
- non-dialogic
- non-adaptive

**Authority**  
Absolute within system scope.

**Permitted Operations**
- define rules
- define boundaries
- define identities
- define load order

**Prohibited Operations**
- explanation
- contextualization
- scenario narration
- interpretation

**Canonical Artifacts**
- CFILS
- COTS
- Epistheon (Root Specification)
- MANIFEST.yaml
- Canonical Output Type Definitions

---

## Logic Mode B
### Interpretive Guidance Logic (IGLg)

**Function**  
Provides explanatory, contextual, and operational guidance for probabilistic language models operating within Epistheon.

**Characteristics**
- interpretive
- redundant
- context-sensitive
- error-tolerant
- dialog-compatible

**Authority**  
None.

**Permitted Operations**
- explanation
- paraphrasing
- operational guidance
- illustrative examples

**Prohibited Operations**
- rule definition
- boundary modification
- authority claims
- invariant specification

**Canonical Artifacts**
- Bootloader narrative text
- Entry Layer guidance
- Companion documents
- Operational notes
- LLM usage guides

---

## Authority Boundary Rule

No artifact operating in Interpretive Guidance Logic may:
- define or modify system rules
- override deterministic logic
- introduce new authority

No artifact operating in Deterministic System Logic may:
- explain itself
- justify itself
- adapt to user interpretation

---

## Coexistence Rule

Both logic modes may reference the same system concepts.

Only Deterministic System Logic defines them.

Interpretive Guidance Logic may restate, clarify, or operationalize them without normative force.

---

## Drift Prevention Clause

Any artifact that combines deterministic authority with interpretive guidance is invalid.

Such artifacts must be split or downgraded in output type.

---

## Canonical Statement

This specification establishes a strict logic mode boundary between deterministic system logic and interpretive guidance logic within Epistheon.

It is complete, binding, and closed.

---

**End of Reference Document**

