#version 330 core

in vec4 vColor;
in vec2 vTexCoord;

uniform float uTime;

uniform sampler2D uTexture;
uniform float uDepth;

out vec4 fragColor;
out float gl_FragDepth;

void main()
{
    vec4 texel = texture(uTexture, vTexCoord) * vColor;

    if (texel.a == 0.0)
        discard;

    fragColor = texel;
    gl_FragDepth = uDepth;
}