#version 330 core

in vec2 vTexCoord;

uniform sampler2D uTextureUnit;
uniform vec4 uColor;
uniform float uDepth;

out vec4 fragColor;
out float gl_FragDepth;

void main()
{
    vec4 texel = texture(uTextureUnit, vTexCoord) * uColor;

    if (texel.a == 0.0)
        discard;

    vec3 lum = vec3(0.299, 0.587, 0.114);
    vec3 gray = vec3(dot(texel.rgb, lum));

    fragColor = vec4(gray, texel.a);
    gl_FragDepth = uDepth;
}