#version 330 core

in vec2 vTexCoord;

uniform sampler2D uTextureUnit;
uniform vec4 uColor;
uniform float uDepth;

out vec4 fragColor;
out float gl_FragDepth;

void main()
{
    vec4 texel = texture(uTextureUnit, vTexCoord) * uColor;

    if (texel.a == 0.0)
        discard;

    vec3 inverse = vec3(1.0 - texel.r, 1.0 - texel.g, 1.0 - texel.b);

    fragColor = vec4(inverse, texel.a);
    gl_FragDepth = uDepth;
}