#version 330 core

in vec2 vTexCoord;

uniform sampler2D uTextureUnit;
uniform vec4 uColor;
uniform float uDepth;

out vec4 fragColor;
out float gl_FragDepth;

void main()
{
    vec4 texel = texture(uTextureUnit, vTexCoord) * uColor;

    if (texel.a == 0.0)
        discard;

    vec3 sepia;
    sepia.r = texel.r * 0.393 + texel.g * 0.769 + texel.b * 0.189;
    sepia.g = texel.r * 0.349 + texel.g * 0.686 + texel.b * 0.168;
    sepia.b = texel.r * 0.272 + texel.g * 0.534 + texel.b * 0.131;

    fragColor = vec4(sepia, texel.a);
    gl_FragDepth = uDepth;
}