#version 330 core

in vec2 vTexCoord;

uniform float uTime;

uniform sampler2D uTextureUnit;
uniform vec4 uColor;
uniform float uDepth;

out vec4 fragColor;
out float gl_FragDepth;

void main()
{    
    vec4 texel = texture(uTextureUnit, vTexCoord) * uColor;

    if (texel.a == 0.0)
        discard;

    fragColor = texel;
    gl_FragDepth = uDepth;
}  