#version 330 core

layout (location = 0) in vec4 aVertex; // <vec2 aPosition, vec2 aTexCoord>

layout (std140) uniform Data
{
    mat4 ubProjectionMatrix;
};

uniform float uTime;

uniform mat4 uModelMatrix;

out vec2 vTexCoord;

void main()
{
    gl_Position = ubProjectionMatrix * uModelMatrix * vec4(aVertex.xy, 1.0, 1.0);
    vTexCoord = aVertex.zw;
} 