DIM w AS INT,h AS INT,sizeX AS INT,sizeY AS INT
w=256
h=256
sizeX=(w SHR 3)+1
sizeY=(h SHR 3)+1
DIM umap(sizeX*sizeY) AS INT,vmap(sizeX*sizeY) AS INT,zmap(sizeX*sizeY) AS INT

FUNCTION SetMap(u AS INT,v AS INT,z AS INT,ofs AS INT)
    SHARE umap(),vmap(),zmap()
    umap(ofs)=u
    vmap(ofs)=v
    zmap(ofs)=z
END FUNCTION

FUNCTION AddRGB(t AS INT,x AS INT,y AS INT,add AS INT) AS LONG
    DIM x4 AS INT,y4 AS INT
    DIM h1 AS INT,h2 AS INT,h3 AS INT,h4 AS INT
    DIM px AS INT,py AS INT
    DIM col1 AS LONG,col2 AS LONG,col3 AS LONG,col4 AS LONG
    DIM c1 AS INT,c2 AS INT,c3 AS INT,c4 AS INT
    DIM r AS INT,g AS INT,b AS INT

    TARGET BITMAP t

    x4=(x AND 65535) SHR 8
    y4=(y AND 65535) SHR 8

    h1=(256-x4)*(256-y4)
    h2=x4*(256-y4)
    h3=(256-x4)*y4
    h4=x4*y4

    px=x SHR 16
    py=y SHR 16

    px=px AND 255
    py=(py AND 255) SHL 8

    col1=PEEK(px+py)
    col3=PEEK((px+(py+256)) AND 65535)

    px=(px+1) AND 255

    col2=PEEK(px+py)
    col4=PEEK((px+(py+256)) AND 65535)

    c1=(col1 SHR 16) AND 255
    c2=(col2 SHR 16) AND 255
    c3=(col3 SHR 16) AND 255
    c4=(col4 SHR 16) AND 255

    r=CLAMP((((c1*h1+c2*h2+c3*h3+c4*h4) SHR 16) AND 255)+add,0,255)

    c1=(col1 SHR 8) AND 255
    c2=(col2 SHR 8) AND 255
    c3=(col3 SHR 8) AND 255
    c4=(col4 SHR 8) AND 255

    g=CLAMP(((c1*h1+c2*h2+c3*h3+c4*h4) SHR 16)+add,0,255)

    c1=col1 AND 255
    c2=col2 AND 255
    c3=col3 AND 255
    c4=col4 AND 255

    b=CLAMP(((c1*h1+c2*h2+c3*h3+c4*h4) SHR 16)+add,0,255)

    RETURN (255 SHL 24)+(r SHL 16)+(g SHL 8)+b
END FUNCTION

FUNCTION Distort(s AS INT,d AS INT)
    SHARE sizeX,sizeY,umap(),vmap(),zmap()

    DIM xsize AS INT,ysize AS INT
    DIM mapofs1 AS INT,mapofs2 AS INT
    DIM scrofs AS INT
    DIM ux1 AS INT,ux2 AS INT,ux3 AS INT,ux4 AS INT
    DIM vx1 AS INT,vx2 AS INT,vx3 AS INT,vx4 AS INT
    DIM zx1 AS INT,zx2 AS INT,zx3 AS INT,zx4 AS INT
    DIM uxslope1 AS INT,vxslope1 AS INT,zxslope1 AS INT
    DIM uxslope2 AS INT,vxslope2 AS INT,zxslope2 AS INT
    DIM uy1 AS INT,uy2 AS INT
    DIM vy1 AS INT,vy2 AS INT
    DIM zy1 AS INT,zy2 AS INT
    DIM uyslope AS INT,vyslope AS INT,zyslope AS INT
    DIM q AS LONG

    xsize=sizeX-1
    ysize=sizeY-1

    mapofs1=0
    mapofs2=xsize+1

    scrofs=0

    FOR my=0 TO ysize-1
        FOR mx=0 TO xsize-1
            ux1=umap(mapofs1)
            ux2=umap(mapofs1+1)

            vx1=vmap(mapofs1)
            vx2=vmap(mapofs1+1)

            zx1=zmap(mapofs1)
            zx2=zmap(mapofs1+1)

            uxslope1=(ux2-ux1) SHR 3
            vxslope1=(vx2-vx1) SHR 3
            zxslope1=(zx2-zx1) SHR 3

            ux3=umap(mapofs2)
            ux4=umap(mapofs2+1)

            vx3=vmap(mapofs2)
            vx4=vmap(mapofs2+1)

            zx3=zmap(mapofs2)
            zx4=zmap(mapofs2+1)

            mapofs1=mapofs1+1
            mapofs2=mapofs2+1

            uxslope2=(ux4-ux3) SHR 3
            vxslope2=(vx4-vx3) SHR 3
            zxslope2=(zx4-zx3) SHR 3

            FOR x=0 TO 7
                uy1=ux1
                uy2=ux3

                vy1=vx1
                vy2=vx3

                zy1=zx1
                zy2=zx3

                uyslope=(uy2-uy1) SHR 3
                vyslope=(vy2-vy1) SHR 3
                zyslope=(zy2-zy1) SHR 3

                FOR y=0 TO 7
                    q=AddRGB(s,uy1,vy1,zy1 SHR 16)
                    TARGET BITMAP d
                    POKE scrofs,q

                    scrofs=scrofs+256

                    uy1=uy1+uyslope
                    vy1=vy1+vyslope
                    zy1=zy1+zyslope
                NEXT y

                scrofs=scrofs-((256 SHL 3)-1)

                ux1=ux1+uxslope1
                ux3=ux3+uxslope2
                vx1=vx1+vxslope1
                vx3=vx3+vxslope2
                zx1=zx1+zxslope1
                zx3=zx3+zxslope2
            NEXT x
        NEXT mx

        scrofs=scrofs+((256 SHL 3)-256)

        mapofs1=mapofs1+1
        mapofs2=mapofs2+1
    NEXT my
END FUNCTION

DIM frame AS DOUBLE
DIM startTime AS INT
DIM sx AS INT,sy AS INT
DIM fangle AS DOUBLE,zoom AS DOUBLE,index AS INT
DIM xm AS INT,ym AS INT
DIM fz AS DOUBLE,fx AS DOUBLE,fy AS DOUBLE
DIM dx AS INT,dy AS INT
DIM r AS DOUBLE
DIM d AS DOUBLE,tx AS INT,ty AS INT

CLEAR ALL
BITMAP 1 LOAD "Texture.bmp"
BITMAP 2 NEW 256,256
TARGET BITMAP 2
SMOOTH BITMAP 2
SPRITE 2 BIND BITMAP 2 SHOW FIT

frame=0

startTime=TIME

DO UNTIL INKEY$=CHR$(27)
    frame=(TIME-startTime)/80
    'frame=385.775

    sx=sizeX
    sy=sizeY

    fangle=frame/60
    zoom=(SIN(frame/30)*COS(frame/30)+1)*400-300
    index=0

    FOR y=0 TO sy-1
        FOR x=0 TO sx-1
            xm=x-20
            ym=y-13

            fz=0

            fx=((x*8-128)*COS(fangle))-((y*8-128)*SIN(fangle))
            fy=((y*8-128)*COS(fangle))+((x*8-128)*SIN(fangle))

            fz=fz+(COS((ym/4+xm*2)/8+frame/37)*SIN((ym)/8+frame/7)*70)
            fz=fz+(COS((ym*2+xm)/8+frame/7)*70)

            dx=(x SHL 3)-128
            dy=(y SHL 3)-128

            r=((dx*dx)+(dy*dy))*SIN(frame/40)/140
            fz=fz+r

            d=2048/(fz+512+47+zoom+r)
            tx=d*fx*256/2.5
            ty=d*fy*256/2.5

            SetMap(tx SHL 8,ty SHL 8,INT(fz*65536),index)

            index=index+1
        NEXT x
    NEXT y

    Distort(1,2)
LOOP
END
