CLEAR ALL
IF COPILOT THEN GOTO launch
PRINT "A valid OpenAI API Key is required to use this program."
PRINT
PRINT "See the documentation and openai.com for more information."
GETKEY a$
END
launch:
BACKGROUND RGB(64,64,64)
BITMAP 1 NEW 1024,1024
SPRITE 1 BIND BITMAP 1 SHOW
BITMAP 2 NEW 1280,800
SPRITE 2 BIND BITMAP 2 SHOW PRIORITY 100
TARGET BITMAP 2
INK RGB(0,0,0,128)
RECT FILL 10-5,50-10,1270+5,275+10
BITMAP 3 NEW 320,200
SHADER 1 LOAD "GeodesicTiling.fs"
SPRITE 3 BIND BITMAP 3 SET SHADER 1
model$="dalle3"
s=1
q=1
b$="Empty"
c$=""
d=0
DO
    m$="DALL-E 3"
    SELECT CASE s
        CASE 1
            s$="Square (1024x1024)"
        CASE 2
            s$="Wide (1792x1024)"
        CASE 3
            s$="Tall (1024x1792)"
    END SELECT
    SELECT CASE q
        CASE 1
            q$="Standard"
        CASE 2
            q$="HD"
    END SELECT
    CLS
    INK RGB(255,255,255)
    PRINT LINE CENTER "DALL-E",,RGB(255,0,0)
    LOCATE ,TEXT.ROWS-2
    PRINT LINE CENTER b$
    PRINT LINE CENTER c$
    LOCATE ,3
    PRINT " (1) Generate a new image"
    PRINT " (2) Regenerate the image"
    PRINT " (3) Change the model" TAB(35) m$
    PRINT " (4) Change the size" TAB(35) s$
    PRINT " (5) Change the quality" TAB(35) q$
    PRINT " (6) Save the current image"
    PRINT " (Q) Quit"
    GETKEY n$
    SELECT CASE LCASE$(n$)
        CASE "1"
            PRINT
            LINE INPUT " ";a$
            a$=TRIM$(a$)
            IF a$<>"" THEN
                prompt$=a$
                d=1
            END IF
        CASE "2"
            PRINT
            a$=b$
            LINE INPUT " ";a$ PRESERVE
            a$=TRIM$(a$)
            IF a$<>"" THEN
                prompt$=a$
                d=1
            END IF
            d=1
        CASE "3"
            model$="dalle3"
        CASE "4"
            s=s+1
            IF s>3 THEN s=1
        CASE "5"
            q=q+1
            IF q>2 THEN q=1
        CASE "6"
            IF b$<>"Empty" THEN
                IF c$="" THEN c$=SuggestFilename$(b$)
                PRINT
                a$=c$
                LINE INPUT " ";a$ PRESERVE
                a$=TRIM$(a$)
                IF a$<>"" THEN BITMAP 1 SAVE a$
                c$=a$
            END IF
        CASE "q"
            EXIT DO
    END SELECT
    IF d THEN
        IF prompt$<>"" THEN
            SPRITE 3 SHOW
            DRAW BITMAP 1,prompt$,s,q$
            SPRITE 3 HIDE
            b$=prompt$
            c$=""
            prompt$=""
        END IF
        d=0
    END IF
LOOP
END
FUNCTION SuggestFilename$(d$)
    CHAT "Print an original filename to store a picture generated by '"+d$+"'." TO f$
    f$=TRIM$(f$,CHR$(34))
    IF INSTR(f$,".")=0 THEN f$=f$+".jpg"
    SuggestFilename$=f$
END FUNCTION
