CLEAR ALL

' -- setup tilemap
BITMAP 1 LOAD "TiledSet.png"
TILESET 1 NEW 16,16,1
TILEMAP 1 NEW 20,12,1
SPRITE 1 BIND TILEMAP 1 SHOW ANCHOR 0,0 MOVE 0,0 XYSIZE 4,4

' -- setup cursor
BITMAP 2 NEW 16,16
TARGET BITMAP 2
INK RGB(255,255,0)
RECT 0,0,15,15
SPRITE 2 BIND BITMAP 2 SHOW XYSIZE 4,4

' -- setup selector
BITMAP 3 NEW 16,16
TARGET BITMAP 3
INK RGB(255,0,0)
RECT 0,0,15,15
SPRITE 3 BIND BITMAP 3 SHOW XYSIZE 4,4 MOVE 19*64+32,32

TARGET TILEMAP 1
TBACKGROUND RGB(20,40,80)
INK RGB(255,255,255)
DrawTileset()

t=1
DO
    mx=INT(CLAMP(MOUSE.X/64,0,19))
    my=INT(CLAMP(MOUSE.Y/64,0,11))
    inx=my*20+mx
    INK RGB(255,255,255)
    HIGHLIGHT RGB(0,0,0)
    LOCATE 1,1
    ? "X: ";USING$("####",mx);", Y:";USING$("####",my)
    HIGHLIGHT 0
    SPRITE 2 MOVE mx*64+32,my*64+32
    b=TPEEK(inx,0)
    IF mx<19 THEN TPOKE inx,t
    PAUSE
    IF mx<19 THEN
        IF MOUSE.BUTTONS=1 THEN
            TPOKE inx,t
        ELSE IF MOUSE.BUTTONS=2 THEN
            TPOKE inx,0
        ELSE
            TPOKE inx,b
        END IF
    ELSE
        IF my<TILESET.COUNT(1)-1 AND MOUSE.BUTTONS=1 THEN
            t=b
            SPRITE 3 MOVE 19*64+32,(t-1)*64+32
        END IF
    END IF
LOOP UNTIL INKEY$=CHR$(27)
END
FUNCTION DrawTileset()
    HIGHLIGHT RGB(0,0,0)
    PUT VLINE 19,0,11,0
    FOR i=1 TO TILESET.COUNT(1)-1
        PUT TILE 19,i-1,i
    NEXT i
    HIGHLIGHT 0
END FUNCTION
