' based on code from https://www.youtube.com/watch?v=ybLZyY655iY

CLEAR ALL
BACKGROUND RGB(135,206,235)
LOCATE ,TEXT.ROWS-9
PRINT "Use the arrow keys to rotate and move forward/backward. Press Space to load a new map."
PRINT
PRINT "Use 'Q' and 'A' to change the NEAR argument."
PRINT "Use 'W' and 'S' to change the FAR argument."
PRINT "Use 'Z' and 'X' to change the FOVHALF argument."
PRINT
PRINT "Use 'R' to reset the NEAR, FAR, and FOVHALF arguments."
PRINT
PRINT "Press Esc to quit."
WIDTH=400:HEIGHT=250 'WIDTH=640:HEIGHT=400
BITMAP 1 LOAD "MarioKart-1.png"
SCREEN BITMAP WIDTH,HEIGHT
r=1:d=1:n=1
DO
    IF r THEN
        worldX=1000.915
        worldY=1000.575
        worldA=4.700
        near=0.005
        far=0.020
        fovHalf=PI/4.0
        r=0
    END IF
    IF d THEN
        ZONE 10
        LOCATE 1,1
        PRINT "worldx: ";USING$("####.###",worldx),
        PRINT "worldy: ";USING$("####.###",worldy),
        PRINT "worlda: ";USING$("####.###",worlda),
        PRINT "near: ";USING$("####.###",near),
        PRINT "far: ";USING$("####.###",far),
        PRINT "fovHalf: ";USING$("####.###",fovHalf)
        VIEW FRUSTUM BITMAP 1,worldX,worldY,worldA,near,far,fovHalf WINDOW 0,HEIGHT/3,WIDTH-1,HEIGHT-1
        d=0
    END IF
    IF KEY.PRESSED(VK_ESC) THEN EXIT DO
    IF KEY.PRESSED(VK_SPACE) THEN
        n=n+1:IF n=4 THEN n=1
        BITMAP 1 LOAD "MarioKart-"+STR$(n)+".png"
        SELECT CASE n
            CASE 1:BACKGROUND RGB(135,206,235)
            CASE 2:BACKGROUND RGB(0, 0, 0)
            CASE 3:BACKGROUND RGB(64, 64, 64)
        END SELECT
        d=1
    END IF
    IF KEY.DOWN(VK_LEFT) THEN worldA=worldA-0.05:d=1
    IF KEY.DOWN(VK_RIGHT) THEN worldA=worldA+0.05:d=1
    IF KEY.DOWN(VK_UP) THEN worldX=worldX+(COS(worldA)*0.005):worldY=worldY+(SIN(worldA)*0.005):d=1
    IF KEY.DOWN(VK_DOWN) THEN worldX=worldX-(COS(worldA)*0.005):worldY=worldY-(SIN(worldA)*0.005):d=1
    IF KEY.DOWN(ASC("r")) THEN r=1:d=1
    IF KEY.DOWN(ASC("q")) THEN near=near+0.01:d=1
    IF KEY.DOWN(ASC("a")) THEN near=near-0.01:d=1
    IF KEY.DOWN(ASC("w")) THEN far=far+0.01:d=1
    IF KEY.DOWN(ASC("s")) THEN far=far-0.01:d=1
    IF KEY.DOWN(ASC("z")) THEN fovHalf=fovHalf+0.01:d=1
    IF KEY.DOWN(ASC("x")) THEN fovHalf=fovHalf-0.01:d=1
    PAUSE
LOOP
